﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Xml.Linq;
using UnityEngine;

//BuildingsInfo handles the BuildingsInfo XML data, containing info on all the buildings present to use
public class BuildingsInfo
{
    public Dictionary<string, BuildingModel> BuildingModels { get; private set; } = new Dictionary<string, BuildingModel>();
    public Dictionary<string, BuildingInstance> Buildings { get; private set; } = new Dictionary<string, BuildingInstance>();

    /// <summary>
    /// Parses the buildings info at the specified file path
    /// </summary>
    /// <param name="filePath">The file path to the buildings info file</param>
    /// <returns>Was the parse successful?</returns>
    public bool Parse(string filePath)
    {
        //Load our XML
        TextAsset xmlText = (TextAsset)Resources.Load(filePath);
        XDocument configXML = XDocument.Parse(xmlText.text);

        var skyscrapersXML = (from ele in configXML.Root.Element("Models").Descendants("SkyscraperModel")
                            select ele).ToList();    //Get all the skyscraper elements

        for (int i = 0; i < skyscrapersXML.Count; i++)
        {
            //Create the model and try to parse it
            SkyscraperModel thisSkyscraperModel = new SkyscraperModel();

            if (thisSkyscraperModel.Parse(skyscrapersXML[i]))
            {
                //Parse succeeded, add it
                BuildingModels.Add(thisSkyscraperModel.ID, thisSkyscraperModel);
            }

            else
            {
                Debug.LogError(string.Format("ERROR: Failed to parse skyscraper model index {0}. Perhaps the XML is malformed?", i));
                return false;
            }
        }

        var commercialXML = (from ele in configXML.Root.Element("Models").Descendants("CommercialModel")
                              select ele).ToList();    //Get all the model elements

        for (int i = 0; i < commercialXML.Count; i++)
        {
            //Create the model and try to parse it
            CommercialModel thisCommercialModel = new CommercialModel();

            if (thisCommercialModel.Parse(commercialXML[i]))
            {
                //Parse succeeded, add it
                BuildingModels.Add(thisCommercialModel.ID, thisCommercialModel);
            }

            else
            {
                Debug.LogError(string.Format("ERROR: Failed to parse commercial model index {0}. Perhaps the XML is malformed?", i));
                return false;
            }
        }

        var houseXML = (from ele in configXML.Root.Element("Models").Descendants("HouseModel")
                             select ele).ToList();    //Get all the model elements

        for (int i = 0; i < houseXML.Count; i++)
        {
            //Create the model and try to parse it
            HouseModel thisHouseModel = new HouseModel();

            if (thisHouseModel.Parse(houseXML[i]))
            {
                //Parse succeeded, add it
                BuildingModels.Add(thisHouseModel.ID, thisHouseModel);
            }

            else
            {
                Debug.LogError(string.Format("ERROR: Failed to parse house model index {0}. Perhaps the XML is malformed?", i));
                return false;
            }
        }

        var buildingInstancesXMLList = (from ele in configXML.Root.Element("Buildings").Descendants("BuildingInstance")
                             select ele).ToList();    //Get all the model elements

        for (int i = 0; i < buildingInstancesXMLList.Count; i++)
        {
            //Create the key building instance and try to parse it
            BuildingInstance thisBuildingInstance = new BuildingInstance();

            if (thisBuildingInstance.Parse(buildingInstancesXMLList[i]))
            {
                //Parse succeeded, add it
                Buildings.Add(thisBuildingInstance.ID, thisBuildingInstance);
            }

            else
            {
                Debug.LogError(string.Format("ERROR: Failed to parse building instance index {0}. Perhaps the XML is malformed?", i));
                return false;
            }
        }

        return true;
    }
}

